/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_CONDITION_VARIABLE_H_
#define _SCE_CONDITION_VARIABLE_H_

namespace sce {
	namespace Toolkit{
		namespace NP{
			namespace Utilities {
/// @brief
/// An abstract class defining the interface for a Condition Variable.
///
/// The interface is to be implemented by specific platform implementations.
class ConditionVariable {
public:
	/// @brief
	/// Default constructor. 
	/// 
	/// Doesn't do anything.
	ConditionVariable() {}
	/// @brief
	/// Default virtual destructor. 
	/// 
	/// Need to provide virtual destructor, but no private members.
	virtual ~ConditionVariable() {}

	/// @brief
	/// Abstract method to initialise object.
	///
	/// Abstract method to initialise object.
	/// @return Returns SUCCESS or a generic error value.
	virtual int init()			= 0;
	/// @brief
	/// Abstract method to terminate object.
	///
	/// Abstract method to terminate object.
	/// @return Returns SUCCESS or a generic error value.
	virtual int term()			= 0;

	/// @brief
	/// Abstract method to signal to a thread waiting on this condition.
	///
	/// Abstract method to signal to a thread waiting on this condition.
	/// Which thread is signaled if there is a queue depends on implementation.
	/// @return Returns SUCCESS or a generic error value.
	virtual int signal()		= 0; 
	/// @brief
	/// Abstract method to signal all threads waiting on this condition.
	///
	/// Abstract method to signal all threads waiting on this condition.
	/// @return Returns SUCCESS or a generic error value.
	virtual int	signalAll()		= 0;
	/// @brief
	/// Abstract method to wait on this object
	///
	/// Abstract method to wait on this object
	/// @param time The time in milliseconds to wait before returning a timeout error.
	/// @return Returns SUCCESS or a generic error value.
	virtual int wait(unsigned int time)	const = 0;
	/// @brief
	/// Abstract method to lock the underlying object.
	///
	/// Abstract method to lock the underlying object.
	/// Should only be used during initialisation I think to ensure that nothing waits until it is ready.
	/// @return Returns SUCCESS or a generic error value.
	virtual int lock()			= 0;
	/// @brief
	/// Abstract method to unlock the underlying object.
	///
	/// Abstract method to unlock the underlying object.
	/// @return Returns SUCCESS or a generic error value.
	virtual int unlock()		= 0;
};
			}//end Utilities
		}//end NP
	}//end Toolkit
}//end Sce
#endif


